## ----echo=FALSE, message=FALSE-------------------------------------------
# include this code chunk as-is to set options
knitr::opts_chunk$set(comment=NA, prompt=TRUE)
library(matrixDemos)

## ------------------------------------------------------------------------
(A <- matrix(c(1,2,3,4,5,6,7,8,10), 3, 3)) # a nonsingular matrix
GaussianElimination(A)

(B <- matrix(1:9, 3, 3)) # a singular matrix
GaussianElimination(B)

## ------------------------------------------------------------------------
A # nonsingular
GaussianElimination(A, diag(3)) # find inverse of A

b <- 1:3
GaussianElimination(A, b)  # solve the matrix equation Ax = b

## ------------------------------------------------------------------------
matrixInverse(A, fractions=TRUE)
RREF(A, verbose=TRUE)
Ginv(B, fractions=TRUE)  # a generalized inverse of singular B
B %*% Ginv(B) %*% B   # check

(C <- matrix(1:12, 3, 4)) # rectangular matrix
Ginv(C, fractions=TRUE)
round(C %*% Ginv(C) %*% C, 5)   # check

